using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Linq;
using Crestron;
using Crestron.Logos.SplusLibrary;
using Crestron.Logos.SplusObjects;
using Crestron.SimplSharp;

namespace CrestronModule_GMTTIME
{
    public class CrestronModuleClass_GMTTIME : SplusObject
    {
        static CCriticalSection g_criticalSection = new CCriticalSection();
        
        
        
        
        
        
        
        
        
        
        
        Crestron.Logos.SplusObjects.DigitalInput SET;
        Crestron.Logos.SplusObjects.DigitalInput TIMEREQUEST;
        Crestron.Logos.SplusObjects.AnalogInput GMTMONTH;
        Crestron.Logos.SplusObjects.AnalogInput GMTDAY;
        Crestron.Logos.SplusObjects.AnalogInput GMTYEAR;
        Crestron.Logos.SplusObjects.AnalogInput GMTHOUR;
        Crestron.Logos.SplusObjects.AnalogInput GMTMINUTE;
        Crestron.Logos.SplusObjects.AnalogInput GMTSECONDS;
        Crestron.Logos.SplusObjects.AnalogInput GMTOFFSET;
        Crestron.Logos.SplusObjects.DigitalOutput WAITINGFORTIMEDATA;
        Crestron.Logos.SplusObjects.AnalogOutput LOCALMONTH;
        Crestron.Logos.SplusObjects.AnalogOutput LOCALDAY;
        Crestron.Logos.SplusObjects.AnalogOutput LOCALYEAR;
        Crestron.Logos.SplusObjects.AnalogOutput LOCALHOUR;
        Crestron.Logos.SplusObjects.AnalogOutput LOCALMINUTE;
        Crestron.Logos.SplusObjects.AnalogOutput LOCALSECONDS;
        ushort SAVEDMONTH = 0;
        ushort SAVEDDAY = 0;
        ushort SAVEDYEAR = 0;
        ushort SAVEDHOUR = 0;
        ushort SAVEDMINUTE = 0;
        ushort SAVEDSECONDS = 0;
        ushort GMT_TIMEFLAGS = 0;
        private ushort ISLEAPYEAR (  SplusExecutionContext __context__, ushort IYEAR ) 
            { 
            ushort ITEMP = 0;
            
            
            __context__.SourceCodeLine = 110;
            ITEMP = (ushort) ( 0 ) ; 
            __context__.SourceCodeLine = 112;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt (Mod( IYEAR , 4 ) == 0))  ) ) 
                {
                __context__.SourceCodeLine = 113;
                ITEMP = (ushort) ( 1 ) ; 
                }
            
            __context__.SourceCodeLine = 114;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt (Mod( IYEAR , 100 ) == 0) ) && Functions.TestForTrue ( Functions.BoolToInt (Mod( IYEAR , 400 ) != 0) )) ))  ) ) 
                {
                __context__.SourceCodeLine = 115;
                ITEMP = (ushort) ( 0 ) ; 
                }
            
            __context__.SourceCodeLine = 117;
            return (ushort)( ITEMP) ; 
            
            }
            
        private ushort LASTDAYOFMONTH (  SplusExecutionContext __context__, ushort MONTH0TO11 , ushort YEARXXXX ) 
            { 
            ushort LASTDAY = 0;
            
            
            __context__.SourceCodeLine = 123;
            switch ((int)MONTH0TO11)
            
                { 
                case 0 : 
                case 2 : 
                case 4 : 
                case 6 : 
                case 7 : 
                case 9 : 
                case 11 : 
                
                    { 
                    __context__.SourceCodeLine = 133;
                    LASTDAY = (ushort) ( 31 ) ; 
                    __context__.SourceCodeLine = 134;
                    break ; 
                    } 
                
                goto case 3 ;
                case 3 : 
                goto case 5 ;
                case 5 : 
                goto case 8 ;
                case 8 : 
                goto case 10 ;
                case 10 : 
                
                    { 
                    __context__.SourceCodeLine = 141;
                    LASTDAY = (ushort) ( 30 ) ; 
                    __context__.SourceCodeLine = 142;
                    break ; 
                    } 
                
                goto case 1 ;
                case 1 : 
                
                    { 
                    __context__.SourceCodeLine = 146;
                    if ( Functions.TestForTrue  ( ( ISLEAPYEAR( __context__ , (ushort)( YEARXXXX ) ))  ) ) 
                        {
                        __context__.SourceCodeLine = 147;
                        LASTDAY = (ushort) ( 29 ) ; 
                        }
                    
                    else 
                        {
                        __context__.SourceCodeLine = 149;
                        LASTDAY = (ushort) ( 28 ) ; 
                        }
                    
                    __context__.SourceCodeLine = 150;
                    break ; 
                    } 
                
                goto default;
                default : 
                
                    {
                    __context__.SourceCodeLine = 154;
                    LASTDAY = (ushort) ( 30 ) ; 
                    }
                break;
                
                } 
                
            
            __context__.SourceCodeLine = 156;
            return (ushort)( LASTDAY) ; 
            
            }
            
        private void SETEVERYTHING (  SplusExecutionContext __context__ ) 
            { 
            short TEMPHOUR = 0;
            short TEMPDAY = 0;
            short TEMPMONTH = 0;
            short TEMPYEAR = 0;
            
            
            __context__.SourceCodeLine = 162;
            LOCALSECONDS  .Value = (ushort) ( SAVEDSECONDS ) ; 
            __context__.SourceCodeLine = 163;
            LOCALMINUTE  .Value = (ushort) ( SAVEDMINUTE ) ; 
            __context__.SourceCodeLine = 164;
            TEMPHOUR = (short) ( Mod( ((SAVEDHOUR + _SplusNVRAM.SAVEDGMTOFFSET) + 24) , 24 ) ) ; 
            __context__.SourceCodeLine = 165;
            TEMPDAY = (short) ( SAVEDDAY ) ; 
            __context__.SourceCodeLine = 166;
            TEMPMONTH = (short) ( SAVEDMONTH ) ; 
            __context__.SourceCodeLine = 167;
            TEMPYEAR = (short) ( SAVEDYEAR ) ; 
            __context__.SourceCodeLine = 170;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (SAVEDHOUR + _SplusNVRAM.SAVEDGMTOFFSET) >= 24 ))  ) ) 
                { 
                __context__.SourceCodeLine = 172;
                TEMPDAY = (short) ( (TEMPDAY + 1) ) ; 
                } 
            
            else 
                {
                __context__.SourceCodeLine = 174;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (SAVEDHOUR + _SplusNVRAM.SAVEDGMTOFFSET) < 0 ))  ) ) 
                    { 
                    __context__.SourceCodeLine = 176;
                    TEMPDAY = (short) ( (TEMPDAY - 1) ) ; 
                    } 
                
                }
            
            __context__.SourceCodeLine = 178;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( TEMPDAY < 1 ))  ) ) 
                { 
                __context__.SourceCodeLine = 180;
                TEMPMONTH = (short) ( (TEMPMONTH - 1) ) ; 
                __context__.SourceCodeLine = 181;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( TEMPMONTH < 0 ))  ) ) 
                    {
                    __context__.SourceCodeLine = 182;
                    TEMPDAY = (short) ( LASTDAYOFMONTH( __context__ , (ushort)( 11 ) , (ushort)( (SAVEDYEAR - 1) ) ) ) ; 
                    }
                
                else 
                    {
                    __context__.SourceCodeLine = 184;
                    TEMPDAY = (short) ( LASTDAYOFMONTH( __context__ , (ushort)( TEMPMONTH ) , (ushort)( SAVEDYEAR ) ) ) ; 
                    }
                
                } 
            
            else 
                {
                __context__.SourceCodeLine = 186;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( TEMPDAY > LASTDAYOFMONTH( __context__ , (ushort)( TEMPMONTH ) , (ushort)( SAVEDYEAR ) ) ))  ) ) 
                    { 
                    __context__.SourceCodeLine = 188;
                    TEMPMONTH = (short) ( (TEMPMONTH + 1) ) ; 
                    __context__.SourceCodeLine = 189;
                    TEMPDAY = (short) ( 1 ) ; 
                    } 
                
                }
            
            __context__.SourceCodeLine = 191;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( TEMPMONTH < 0 ))  ) ) 
                { 
                __context__.SourceCodeLine = 193;
                TEMPMONTH = (short) ( 11 ) ; 
                __context__.SourceCodeLine = 194;
                TEMPYEAR = (short) ( (TEMPYEAR - 1) ) ; 
                __context__.SourceCodeLine = 195;
                TEMPDAY = (short) ( LASTDAYOFMONTH( __context__ , (ushort)( TEMPMONTH ) , (ushort)( (SAVEDYEAR - 1) ) ) ) ; 
                } 
            
            else 
                {
                __context__.SourceCodeLine = 197;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( TEMPMONTH > 11 ))  ) ) 
                    { 
                    __context__.SourceCodeLine = 199;
                    TEMPMONTH = (short) ( 0 ) ; 
                    __context__.SourceCodeLine = 200;
                    TEMPYEAR = (short) ( (TEMPYEAR + 1) ) ; 
                    } 
                
                }
            
            __context__.SourceCodeLine = 202;
            LOCALHOUR  .Value = (ushort) ( TEMPHOUR ) ; 
            __context__.SourceCodeLine = 203;
            LOCALDAY  .Value = (ushort) ( TEMPDAY ) ; 
            __context__.SourceCodeLine = 204;
            LOCALMONTH  .Value = (ushort) ( TEMPMONTH ) ; 
            __context__.SourceCodeLine = 205;
            LOCALYEAR  .Value = (ushort) ( TEMPYEAR ) ; 
            __context__.SourceCodeLine = 206;
            Functions.SetDate (  (int) ( LOCALMONTH  .Value ) ,  (int) ( LOCALDAY  .Value ) ,  (int) ( LOCALYEAR  .Value ) ) ; 
            __context__.SourceCodeLine = 207;
            Functions.SetClock (  (int) ( LOCALHOUR  .Value ) ,  (int) ( LOCALMINUTE  .Value ) ,  (int) ( LOCALSECONDS  .Value ) ) ; 
            __context__.SourceCodeLine = 209;
            GenerateUserNotice ( "***> GMTTime:  Setting Clock to {0,2:d}/{1:d2}/{2:d2} {3:d2}:{4:d2}:{5:d2}\r\n", (short)LOCALMONTH  .Value, (short)LOCALDAY  .Value, (short)LOCALYEAR  .Value, (short)LOCALHOUR  .Value, (short)LOCALMINUTE  .Value, (short)LOCALSECONDS  .Value) ; 
            
            }
            
        object SET_OnPush_0 ( Object __EventInfo__ )
        
            { 
            Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
            try
            {
                SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
                
                __context__.SourceCodeLine = 219;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt (GMT_TIMEFLAGS == 63))  ) ) 
                    {
                    __context__.SourceCodeLine = 220;
                    SETEVERYTHING (  __context__  ) ; 
                    }
                
                else 
                    {
                    __context__.SourceCodeLine = 222;
                    Print( "Could not set the time.  Flags = {0:x}\r\n", GMT_TIMEFLAGS) ; 
                    }
                
                
                
            }
            catch(Exception e) { ObjectCatchHandler(e); }
            finally { ObjectFinallyHandler( __SignalEventArg__ ); }
            return this;
            
        }
        
    object TIMEREQUEST_OnPush_1 ( Object __EventInfo__ )
    
        { 
        Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
        try
        {
            SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
            
            __context__.SourceCodeLine = 226;
            GMT_TIMEFLAGS = (ushort) ( 0 ) ; 
            __context__.SourceCodeLine = 227;
            WAITINGFORTIMEDATA  .Value = (ushort) ( 1 ) ; 
            __context__.SourceCodeLine = 228;
            CreateWait ( "TIME_REQUEST_WAIT" , 1000 , TIME_REQUEST_WAIT_Callback ) ;
            __context__.SourceCodeLine = 237;
            RetimeWait ( (int)1000, "TIME_REQUEST_WAIT" ) ; 
            
            
        }
        catch(Exception e) { ObjectCatchHandler(e); }
        finally { ObjectFinallyHandler( __SignalEventArg__ ); }
        return this;
        
    }
    
public void TIME_REQUEST_WAIT_CallbackFn( object stateInfo )
{

    try
    {
        Wait __LocalWait__ = (Wait)stateInfo;
        SplusExecutionContext __context__ = SplusThreadStartCode(__LocalWait__);
        __LocalWait__.RemoveFromList();
        
            
            __context__.SourceCodeLine = 230;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt (GMT_TIMEFLAGS == 63))  ) ) 
                {
                __context__.SourceCodeLine = 231;
                SETEVERYTHING (  __context__  ) ; 
                }
            
            else 
                {
                __context__.SourceCodeLine = 233;
                Print( "Could not set the time.  Flags = {0:X}\r\n", GMT_TIMEFLAGS) ; 
                }
            
            __context__.SourceCodeLine = 234;
            WAITINGFORTIMEDATA  .Value = (ushort) ( 0 ) ; 
            
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler(); }
    
}

object GMTMONTH_OnChange_2 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 242;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( GMTMONTH  .UshortValue <= 12 ))  ) ) 
            { 
            __context__.SourceCodeLine = 244;
            SAVEDMONTH = (ushort) ( GMTMONTH  .UshortValue ) ; 
            __context__.SourceCodeLine = 245;
            GMT_TIMEFLAGS = (ushort) ( (GMT_TIMEFLAGS | 16) ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object GMTDAY_OnChange_3 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 250;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( GMTDAY  .UshortValue <= 31 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( GMTDAY  .UshortValue >= 1 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 252;
            SAVEDDAY = (ushort) ( GMTDAY  .UshortValue ) ; 
            __context__.SourceCodeLine = 253;
            GMT_TIMEFLAGS = (ushort) ( (GMT_TIMEFLAGS | 8) ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object GMTYEAR_OnChange_4 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 258;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( GMTYEAR  .UshortValue <= 2100 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( GMTYEAR  .UshortValue >= 2000 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 260;
            SAVEDYEAR = (ushort) ( GMTYEAR  .UshortValue ) ; 
            __context__.SourceCodeLine = 261;
            GMT_TIMEFLAGS = (ushort) ( (GMT_TIMEFLAGS | 32) ) ; 
            } 
        
        else 
            {
            __context__.SourceCodeLine = 263;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( GMTYEAR  .UshortValue <= 2228 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( GMTYEAR  .UshortValue >= 2128 ) )) ))  ) ) 
                { 
                __context__.SourceCodeLine = 269;
                if ( Functions.TestForTrue  ( ( ISLEAPYEAR( __context__ , (ushort)( (GMTYEAR  .UshortValue - 128) ) ))  ) ) 
                    { 
                    __context__.SourceCodeLine = 271;
                    SAVEDYEAR = (ushort) ( (GMTYEAR  .UshortValue - 128) ) ; 
                    __context__.SourceCodeLine = 272;
                    GMT_TIMEFLAGS = (ushort) ( (GMT_TIMEFLAGS | 32) ) ; 
                    } 
                
                } 
            
            }
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object GMTHOUR_OnChange_5 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 279;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( GMTHOUR  .UshortValue <= 23 ))  ) ) 
            { 
            __context__.SourceCodeLine = 281;
            SAVEDHOUR = (ushort) ( GMTHOUR  .UshortValue ) ; 
            __context__.SourceCodeLine = 282;
            GMT_TIMEFLAGS = (ushort) ( (GMT_TIMEFLAGS | 4) ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object GMTMINUTE_OnChange_6 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 287;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( GMTMINUTE  .UshortValue <= 59 ))  ) ) 
            { 
            __context__.SourceCodeLine = 289;
            SAVEDMINUTE = (ushort) ( GMTMINUTE  .UshortValue ) ; 
            __context__.SourceCodeLine = 290;
            GMT_TIMEFLAGS = (ushort) ( (GMT_TIMEFLAGS | 2) ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object GMTSECONDS_OnChange_7 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 295;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( GMTSECONDS  .UshortValue <= 59 ))  ) ) 
            { 
            __context__.SourceCodeLine = 297;
            SAVEDSECONDS = (ushort) ( GMTSECONDS  .UshortValue ) ; 
            __context__.SourceCodeLine = 298;
            GMT_TIMEFLAGS = (ushort) ( (GMT_TIMEFLAGS | 1) ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object GMTOFFSET_OnChange_8 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 303;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( GMTOFFSET  .UshortValue <= 14 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( GMTOFFSET  .UshortValue >= Functions.ToSignedLongInteger( -( 12 ) ) ) )) ))  ) ) 
            {
            __context__.SourceCodeLine = 304;
            _SplusNVRAM.SAVEDGMTOFFSET = (short) ( GMTOFFSET  .ShortValue ) ; 
            }
        
        __context__.SourceCodeLine = 305;
        Print( "GMTOffset = {0:d}, SavedGMTOffset = {1:d}\r\n", (short)GMTOFFSET  .UshortValue, (short)_SplusNVRAM.SAVEDGMTOFFSET) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

public override object FunctionMain (  object __obj__ ) 
    { 
    try
    {
        SplusExecutionContext __context__ = SplusFunctionMainStartCode();
        
        __context__.SourceCodeLine = 316;
        LOCALHOUR  .Value = (ushort) ( Functions.GetHourNum() ) ; 
        __context__.SourceCodeLine = 317;
        LOCALMINUTE  .Value = (ushort) ( Functions.GetMinutesNum() ) ; 
        __context__.SourceCodeLine = 318;
        LOCALSECONDS  .Value = (ushort) ( Functions.GetSecondsNum() ) ; 
        __context__.SourceCodeLine = 319;
        LOCALMONTH  .Value = (ushort) ( Functions.GetMonthNum() ) ; 
        __context__.SourceCodeLine = 320;
        LOCALDAY  .Value = (ushort) ( Functions.GetDateNum() ) ; 
        __context__.SourceCodeLine = 321;
        LOCALYEAR  .Value = (ushort) ( Functions.GetYearNum() ) ; 
        __context__.SourceCodeLine = 323;
        GMT_TIMEFLAGS = (ushort) ( 0 ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler(); }
    return __obj__;
    }
    

public override void LogosSplusInitialize()
{
    _SplusNVRAM = new SplusNVRAM( this );
    
    SET = new Crestron.Logos.SplusObjects.DigitalInput( SET__DigitalInput__, this );
    m_DigitalInputList.Add( SET__DigitalInput__, SET );
    
    TIMEREQUEST = new Crestron.Logos.SplusObjects.DigitalInput( TIMEREQUEST__DigitalInput__, this );
    m_DigitalInputList.Add( TIMEREQUEST__DigitalInput__, TIMEREQUEST );
    
    WAITINGFORTIMEDATA = new Crestron.Logos.SplusObjects.DigitalOutput( WAITINGFORTIMEDATA__DigitalOutput__, this );
    m_DigitalOutputList.Add( WAITINGFORTIMEDATA__DigitalOutput__, WAITINGFORTIMEDATA );
    
    GMTMONTH = new Crestron.Logos.SplusObjects.AnalogInput( GMTMONTH__AnalogSerialInput__, this );
    m_AnalogInputList.Add( GMTMONTH__AnalogSerialInput__, GMTMONTH );
    
    GMTDAY = new Crestron.Logos.SplusObjects.AnalogInput( GMTDAY__AnalogSerialInput__, this );
    m_AnalogInputList.Add( GMTDAY__AnalogSerialInput__, GMTDAY );
    
    GMTYEAR = new Crestron.Logos.SplusObjects.AnalogInput( GMTYEAR__AnalogSerialInput__, this );
    m_AnalogInputList.Add( GMTYEAR__AnalogSerialInput__, GMTYEAR );
    
    GMTHOUR = new Crestron.Logos.SplusObjects.AnalogInput( GMTHOUR__AnalogSerialInput__, this );
    m_AnalogInputList.Add( GMTHOUR__AnalogSerialInput__, GMTHOUR );
    
    GMTMINUTE = new Crestron.Logos.SplusObjects.AnalogInput( GMTMINUTE__AnalogSerialInput__, this );
    m_AnalogInputList.Add( GMTMINUTE__AnalogSerialInput__, GMTMINUTE );
    
    GMTSECONDS = new Crestron.Logos.SplusObjects.AnalogInput( GMTSECONDS__AnalogSerialInput__, this );
    m_AnalogInputList.Add( GMTSECONDS__AnalogSerialInput__, GMTSECONDS );
    
    GMTOFFSET = new Crestron.Logos.SplusObjects.AnalogInput( GMTOFFSET__AnalogSerialInput__, this );
    m_AnalogInputList.Add( GMTOFFSET__AnalogSerialInput__, GMTOFFSET );
    
    LOCALMONTH = new Crestron.Logos.SplusObjects.AnalogOutput( LOCALMONTH__AnalogSerialOutput__, this );
    m_AnalogOutputList.Add( LOCALMONTH__AnalogSerialOutput__, LOCALMONTH );
    
    LOCALDAY = new Crestron.Logos.SplusObjects.AnalogOutput( LOCALDAY__AnalogSerialOutput__, this );
    m_AnalogOutputList.Add( LOCALDAY__AnalogSerialOutput__, LOCALDAY );
    
    LOCALYEAR = new Crestron.Logos.SplusObjects.AnalogOutput( LOCALYEAR__AnalogSerialOutput__, this );
    m_AnalogOutputList.Add( LOCALYEAR__AnalogSerialOutput__, LOCALYEAR );
    
    LOCALHOUR = new Crestron.Logos.SplusObjects.AnalogOutput( LOCALHOUR__AnalogSerialOutput__, this );
    m_AnalogOutputList.Add( LOCALHOUR__AnalogSerialOutput__, LOCALHOUR );
    
    LOCALMINUTE = new Crestron.Logos.SplusObjects.AnalogOutput( LOCALMINUTE__AnalogSerialOutput__, this );
    m_AnalogOutputList.Add( LOCALMINUTE__AnalogSerialOutput__, LOCALMINUTE );
    
    LOCALSECONDS = new Crestron.Logos.SplusObjects.AnalogOutput( LOCALSECONDS__AnalogSerialOutput__, this );
    m_AnalogOutputList.Add( LOCALSECONDS__AnalogSerialOutput__, LOCALSECONDS );
    
    TIME_REQUEST_WAIT_Callback = new WaitFunction( TIME_REQUEST_WAIT_CallbackFn );
    
    SET.OnDigitalPush.Add( new InputChangeHandlerWrapper( SET_OnPush_0, false ) );
    TIMEREQUEST.OnDigitalPush.Add( new InputChangeHandlerWrapper( TIMEREQUEST_OnPush_1, false ) );
    GMTMONTH.OnAnalogChange.Add( new InputChangeHandlerWrapper( GMTMONTH_OnChange_2, false ) );
    GMTDAY.OnAnalogChange.Add( new InputChangeHandlerWrapper( GMTDAY_OnChange_3, false ) );
    GMTYEAR.OnAnalogChange.Add( new InputChangeHandlerWrapper( GMTYEAR_OnChange_4, false ) );
    GMTHOUR.OnAnalogChange.Add( new InputChangeHandlerWrapper( GMTHOUR_OnChange_5, false ) );
    GMTMINUTE.OnAnalogChange.Add( new InputChangeHandlerWrapper( GMTMINUTE_OnChange_6, false ) );
    GMTSECONDS.OnAnalogChange.Add( new InputChangeHandlerWrapper( GMTSECONDS_OnChange_7, false ) );
    GMTOFFSET.OnAnalogChange.Add( new InputChangeHandlerWrapper( GMTOFFSET_OnChange_8, false ) );
    
    _SplusNVRAM.PopulateCustomAttributeList( true );
    
    NVRAM = _SplusNVRAM;
    
}

public override void LogosSimplSharpInitialize()
{
    
    
}

public CrestronModuleClass_GMTTIME ( string InstanceName, string ReferenceID, Crestron.Logos.SplusObjects.CrestronStringEncoding nEncodingType ) : base( InstanceName, ReferenceID, nEncodingType ) {}


private WaitFunction TIME_REQUEST_WAIT_Callback;


const uint SET__DigitalInput__ = 0;
const uint TIMEREQUEST__DigitalInput__ = 1;
const uint GMTMONTH__AnalogSerialInput__ = 0;
const uint GMTDAY__AnalogSerialInput__ = 1;
const uint GMTYEAR__AnalogSerialInput__ = 2;
const uint GMTHOUR__AnalogSerialInput__ = 3;
const uint GMTMINUTE__AnalogSerialInput__ = 4;
const uint GMTSECONDS__AnalogSerialInput__ = 5;
const uint GMTOFFSET__AnalogSerialInput__ = 6;
const uint WAITINGFORTIMEDATA__DigitalOutput__ = 0;
const uint LOCALMONTH__AnalogSerialOutput__ = 0;
const uint LOCALDAY__AnalogSerialOutput__ = 1;
const uint LOCALYEAR__AnalogSerialOutput__ = 2;
const uint LOCALHOUR__AnalogSerialOutput__ = 3;
const uint LOCALMINUTE__AnalogSerialOutput__ = 4;
const uint LOCALSECONDS__AnalogSerialOutput__ = 5;

[SplusStructAttribute(-1, true, false)]
public class SplusNVRAM : SplusStructureBase
{

    public SplusNVRAM( SplusObject __caller__ ) : base( __caller__ ) {}
    
    [SplusStructAttribute(0, false, true)]
            public short SAVEDGMTOFFSET = 0;
            
}

SplusNVRAM _SplusNVRAM = null;

public class __CEvent__ : CEvent
{
    public __CEvent__() {}
    public void Close() { base.Close(); }
    public int Reset() { return base.Reset() ? 1 : 0; }
    public int Set() { return base.Set() ? 1 : 0; }
    public int Wait( int timeOutInMs ) { return base.Wait( timeOutInMs ) ? 1 : 0; }
}
public class __CMutex__ : CMutex
{
    public __CMutex__() {}
    public void Close() { base.Close(); }
    public void ReleaseMutex() { base.ReleaseMutex(); }
    public int WaitForMutex() { return base.WaitForMutex() ? 1 : 0; }
}
 public int IsNull( object obj ){ return (obj == null) ? 1 : 0; }
}


}
